//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define WIN32_LEAN_AND_MEAN

#include <Windows.H>
#include <WindowsX.H>
#include <SQL.H>
#include <SqlExt.H>
#include <ShellAPI.H>
#include <ShlOBJ.H>
#include <Stdio.H>
#include <Stdlib.H>

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "SQLClass.H"
#include "SQLRoutines.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

SQLBasics::SQLBasics()
{
    Connected = false;
    DBDisconnect();
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

SQLBasics::~SQLBasics()
{
    DBDisconnect();
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SQLBasics::DBConnect(char *Driver, char *Server, char *UID, char *PWD, char *Database)
{
    SQLRETURN Result;
    char ConnectString[MAXSQLBUFLEN];

    if(Connected)
        return false;

    sprintf(ConnectString, "DRIVER=%s; SERVER=%s; UID=%s; PWD=%s; DATABASE=%s;", Driver, Server, UID, PWD, Database);

    SQLCHAR ConnStrOut[MAXSQLBUFLEN];
    SQLSMALLINT cbConnStrOut = 0;

    // Allocate the environment handle
    Result = SQLAllocHandle(SQL_HANDLE_ENV, SQL_NULL_HANDLE, &SQLEnvironment);
    if(!SQL_SUCCEEDED(Result))
    {
        return false;
    }

    // Set the environment attributes
    Result = SQLSetEnvAttr(SQLEnvironment, SQL_ATTR_ODBC_VERSION, (void *) SQL_OV_ODBC3, 0);
    if(!SQL_SUCCEEDED(Result))
    {
        SQLFreeHandle(SQL_HANDLE_ENV, SQLEnvironment);
        return false;
    }

    // Allocate the connection handle
    Result = SQLAllocHandle(SQL_HANDLE_DBC, SQLEnvironment, &SQLConnection);
    if(!SQL_SUCCEEDED(Result))
    {
        SQLFreeHandle(SQL_HANDLE_DBC, SQLConnection);
        SQLFreeHandle(SQL_HANDLE_ENV, SQLEnvironment);
        return false;
    }

    // Set login timeout to 5 seconds.
    SQLSetConnectOption(SQLConnection, SQL_LOGIN_TIMEOUT, 5);
    SQLSetConnectOption(SQLConnection, SQL_CURSOR_TYPE, SQL_CURSOR_STATIC);

    // Connect
    Result = SQLDriverConnect(
        SQLConnection,            // Connection handle
        NULL,                     // Window handle
        (SQLCHAR *)ConnectString, // Input connect string
        SQL_NTS,                  // Null-terminated string
        ConnStrOut,               // Address of output buffer
        MAXSQLBUFLEN,             // Size of output buffer
        &cbConnStrOut,            // Address of output length
        SQL_DRIVER_NOPROMPT
    );

    if(!SQL_SUCCEEDED(Result))
    {
        SQLFreeHandle(SQL_HANDLE_DBC, SQLConnection);
        SQLFreeHandle(SQL_HANDLE_ENV, SQLEnvironment);
        return false;
    }

    Connected = true;

    return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void SQLBasics::DBGetErrorMessage(char *ReturnChar, HSTMT StatementHandle)
{
    if(Connected)
	{
	    SQLCHAR     szSqlState[20];
	    SQLINTEGER  ssErr;
	    SQLSMALLINT cbErrorMsg;

	    SQLError(SQLEnvironment, SQLConnection, StatementHandle, szSqlState, &ssErr, (SQLCHAR *)ReturnChar, MAXSQLCONNOUT, &cbErrorMsg);
	}
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void SQLBasics::DBDisconnect(void)
{
    if(Connected)
    {
        SQLDisconnect(SQLConnection);
        SQLFreeHandle(SQL_HANDLE_DBC, SQLConnection);
        SQLFreeHandle(SQL_HANDLE_ENV, SQLEnvironment);
    }

    SQLConnection = NULL;
    SQLEnvironment = NULL;

    Connected = false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SQLBasics::DBExecute(char *Statement, HSTMT *StatementHandle)
{
    if(!Connected)
        return false;

    SQLRETURN Result = 0;

    Result = SQLAllocHandle(SQL_HANDLE_STMT, SQLConnection, StatementHandle);
    if(SQL_SUCCEEDED(Result))
    {
        Result = SQLPrepare(*StatementHandle, (unsigned char *)Statement, strlen(Statement));
        if(SQL_SUCCEEDED(Result))
        {
            Result = SQLExecute(*StatementHandle);
            if(Result == SQL_SUCCESS || Result == SQL_SUCCESS_WITH_INFO || Result == SQL_NO_DATA)
            {
                return true;
            }
        }
    }

    return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

